<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\EspDeviceController;
use App\Http\Controllers\Api\EspController;
use App\Http\Controllers\Api\BillingController;
use App\Http\Controllers\Api\PaketApiController;
use App\Http\Controllers\Api\MakananApiController;

Route::get('/user', function (Request $request) {
    return Auth::user();
})->middleware('web');

// ESP32 API Routes
Route::prefix('esp')->group(function () {
    Route::post('/heartbeat', [EspController::class, 'heartbeat']);
    Route::get('/relay-status/{device_id}', [EspController::class, 'getRelayStatus']);
    Route::post('/control-relay', [EspController::class, 'controlRelay']);
    Route::post('/control-multiple-relays', [EspController::class, 'controlMultipleRelays']);
});

// Device API Routes for frontend
Route::prefix('devices')->group(function () {
    Route::get('/', [EspDeviceController::class, 'getDevices']);
    Route::post('/check-status', [EspDeviceController::class, 'checkOfflineDevices']);
});

// Ports API Routes for dashboard
Route::prefix('ports')->group(function () {
    Route::get('/', [EspDeviceController::class, 'getPorts']);
});

// Relay Control API Routes for dashboard
Route::prefix('relay')->group(function () {
    Route::post('/control', [EspController::class, 'controlRelay']);
    Route::post('/control-multiple', [EspController::class, 'controlMultipleRelays']);
    Route::post('/update-name', [EspDeviceController::class, 'updateRelayName']);
});

// Billing API Routes
Route::prefix('billing')->group(function () {
    Route::post('/start', [BillingController::class, 'start']);
    Route::post('/stop', [BillingController::class, 'stop']);
    Route::post('/cancel', [BillingController::class, 'cancel']);
    Route::get('/active', [BillingController::class, 'getActiveBilling']);
    Route::post('/check-expired', [BillingController::class, 'checkExpiredTimedBillings']);
    Route::post('/tambah-waktu', [BillingController::class, 'tambahWaktu']);
    Route::post('/move', [BillingController::class, 'move']);
});

Route::get('/paket', [PaketApiController::class, 'index']);

Route::get('/makanan', [MakananApiController::class, 'index']);
