import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\PaketController::index
 * @see app/Http/Controllers/PaketController.php:11
 * @route '/paket'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/paket',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaketController::index
 * @see app/Http/Controllers/PaketController.php:11
 * @route '/paket'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaketController::index
 * @see app/Http/Controllers/PaketController.php:11
 * @route '/paket'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaketController::index
 * @see app/Http/Controllers/PaketController.php:11
 * @route '/paket'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaketController::index
 * @see app/Http/Controllers/PaketController.php:11
 * @route '/paket'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaketController::index
 * @see app/Http/Controllers/PaketController.php:11
 * @route '/paket'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaketController::index
 * @see app/Http/Controllers/PaketController.php:11
 * @route '/paket'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\PaketController::create
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/paket/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaketController::create
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaketController::create
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaketController::create
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaketController::create
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaketController::create
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaketController::create
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\PaketController::store
 * @see app/Http/Controllers/PaketController.php:20
 * @route '/paket'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/paket',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\PaketController::store
 * @see app/Http/Controllers/PaketController.php:20
 * @route '/paket'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaketController::store
 * @see app/Http/Controllers/PaketController.php:20
 * @route '/paket'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\PaketController::store
 * @see app/Http/Controllers/PaketController.php:20
 * @route '/paket'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PaketController::store
 * @see app/Http/Controllers/PaketController.php:20
 * @route '/paket'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\PaketController::show
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}'
 */
export const show = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/paket/{paket}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaketController::show
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}'
 */
show.url = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { paket: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    paket: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        paket: args.paket,
                }

    return show.definition.url
            .replace('{paket}', parsedArgs.paket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaketController::show
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}'
 */
show.get = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaketController::show
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}'
 */
show.head = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaketController::show
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}'
 */
    const showForm = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaketController::show
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}'
 */
        showForm.get = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaketController::show
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}'
 */
        showForm.head = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
/**
* @see \App\Http\Controllers\PaketController::edit
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}/edit'
 */
export const edit = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/paket/{paket}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaketController::edit
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}/edit'
 */
edit.url = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { paket: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    paket: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        paket: args.paket,
                }

    return edit.definition.url
            .replace('{paket}', parsedArgs.paket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaketController::edit
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}/edit'
 */
edit.get = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaketController::edit
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}/edit'
 */
edit.head = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaketController::edit
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}/edit'
 */
    const editForm = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaketController::edit
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}/edit'
 */
        editForm.get = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaketController::edit
 * @see app/Http/Controllers/PaketController.php:0
 * @route '/paket/{paket}/edit'
 */
        editForm.head = (args: { paket: string | number } | [paket: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\PaketController::update
 * @see app/Http/Controllers/PaketController.php:35
 * @route '/paket/{paket}'
 */
export const update = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/paket/{paket}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\PaketController::update
 * @see app/Http/Controllers/PaketController.php:35
 * @route '/paket/{paket}'
 */
update.url = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { paket: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { paket: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    paket: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        paket: typeof args.paket === 'object'
                ? args.paket.id
                : args.paket,
                }

    return update.definition.url
            .replace('{paket}', parsedArgs.paket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaketController::update
 * @see app/Http/Controllers/PaketController.php:35
 * @route '/paket/{paket}'
 */
update.put = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\PaketController::update
 * @see app/Http/Controllers/PaketController.php:35
 * @route '/paket/{paket}'
 */
update.patch = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\PaketController::update
 * @see app/Http/Controllers/PaketController.php:35
 * @route '/paket/{paket}'
 */
    const updateForm = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PaketController::update
 * @see app/Http/Controllers/PaketController.php:35
 * @route '/paket/{paket}'
 */
        updateForm.put = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\PaketController::update
 * @see app/Http/Controllers/PaketController.php:35
 * @route '/paket/{paket}'
 */
        updateForm.patch = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\PaketController::destroy
 * @see app/Http/Controllers/PaketController.php:50
 * @route '/paket/{paket}'
 */
export const destroy = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/paket/{paket}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\PaketController::destroy
 * @see app/Http/Controllers/PaketController.php:50
 * @route '/paket/{paket}'
 */
destroy.url = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { paket: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { paket: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    paket: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        paket: typeof args.paket === 'object'
                ? args.paket.id
                : args.paket,
                }

    return destroy.definition.url
            .replace('{paket}', parsedArgs.paket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaketController::destroy
 * @see app/Http/Controllers/PaketController.php:50
 * @route '/paket/{paket}'
 */
destroy.delete = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\PaketController::destroy
 * @see app/Http/Controllers/PaketController.php:50
 * @route '/paket/{paket}'
 */
    const destroyForm = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PaketController::destroy
 * @see app/Http/Controllers/PaketController.php:50
 * @route '/paket/{paket}'
 */
        destroyForm.delete = (args: { paket: number | { id: number } } | [paket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
const paket = {
    index: Object.assign(index, index),
create: Object.assign(create, create),
store: Object.assign(store, store),
show: Object.assign(show, show),
edit: Object.assign(edit, edit),
update: Object.assign(update, update),
destroy: Object.assign(destroy, destroy),
}

export default paket