import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\MakananController::index
 * @see app/Http/Controllers/MakananController.php:11
 * @route '/makanan'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/makanan',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\MakananController::index
 * @see app/Http/Controllers/MakananController.php:11
 * @route '/makanan'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\MakananController::index
 * @see app/Http/Controllers/MakananController.php:11
 * @route '/makanan'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\MakananController::index
 * @see app/Http/Controllers/MakananController.php:11
 * @route '/makanan'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\MakananController::index
 * @see app/Http/Controllers/MakananController.php:11
 * @route '/makanan'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\MakananController::index
 * @see app/Http/Controllers/MakananController.php:11
 * @route '/makanan'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\MakananController::index
 * @see app/Http/Controllers/MakananController.php:11
 * @route '/makanan'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\MakananController::create
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/makanan/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\MakananController::create
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\MakananController::create
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\MakananController::create
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\MakananController::create
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\MakananController::create
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\MakananController::create
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\MakananController::store
 * @see app/Http/Controllers/MakananController.php:20
 * @route '/makanan'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/makanan',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\MakananController::store
 * @see app/Http/Controllers/MakananController.php:20
 * @route '/makanan'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\MakananController::store
 * @see app/Http/Controllers/MakananController.php:20
 * @route '/makanan'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\MakananController::store
 * @see app/Http/Controllers/MakananController.php:20
 * @route '/makanan'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\MakananController::store
 * @see app/Http/Controllers/MakananController.php:20
 * @route '/makanan'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\MakananController::show
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}'
 */
export const show = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/makanan/{makanan}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\MakananController::show
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}'
 */
show.url = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { makanan: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    makanan: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        makanan: args.makanan,
                }

    return show.definition.url
            .replace('{makanan}', parsedArgs.makanan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\MakananController::show
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}'
 */
show.get = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\MakananController::show
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}'
 */
show.head = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\MakananController::show
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}'
 */
    const showForm = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\MakananController::show
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}'
 */
        showForm.get = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\MakananController::show
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}'
 */
        showForm.head = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
/**
* @see \App\Http\Controllers\MakananController::edit
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}/edit'
 */
export const edit = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/makanan/{makanan}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\MakananController::edit
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}/edit'
 */
edit.url = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { makanan: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    makanan: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        makanan: args.makanan,
                }

    return edit.definition.url
            .replace('{makanan}', parsedArgs.makanan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\MakananController::edit
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}/edit'
 */
edit.get = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\MakananController::edit
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}/edit'
 */
edit.head = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\MakananController::edit
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}/edit'
 */
    const editForm = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\MakananController::edit
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}/edit'
 */
        editForm.get = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\MakananController::edit
 * @see app/Http/Controllers/MakananController.php:0
 * @route '/makanan/{makanan}/edit'
 */
        editForm.head = (args: { makanan: string | number } | [makanan: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\MakananController::update
 * @see app/Http/Controllers/MakananController.php:34
 * @route '/makanan/{makanan}'
 */
export const update = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/makanan/{makanan}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\MakananController::update
 * @see app/Http/Controllers/MakananController.php:34
 * @route '/makanan/{makanan}'
 */
update.url = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { makanan: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { makanan: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    makanan: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        makanan: typeof args.makanan === 'object'
                ? args.makanan.id
                : args.makanan,
                }

    return update.definition.url
            .replace('{makanan}', parsedArgs.makanan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\MakananController::update
 * @see app/Http/Controllers/MakananController.php:34
 * @route '/makanan/{makanan}'
 */
update.put = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\MakananController::update
 * @see app/Http/Controllers/MakananController.php:34
 * @route '/makanan/{makanan}'
 */
update.patch = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\MakananController::update
 * @see app/Http/Controllers/MakananController.php:34
 * @route '/makanan/{makanan}'
 */
    const updateForm = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\MakananController::update
 * @see app/Http/Controllers/MakananController.php:34
 * @route '/makanan/{makanan}'
 */
        updateForm.put = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\MakananController::update
 * @see app/Http/Controllers/MakananController.php:34
 * @route '/makanan/{makanan}'
 */
        updateForm.patch = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\MakananController::destroy
 * @see app/Http/Controllers/MakananController.php:48
 * @route '/makanan/{makanan}'
 */
export const destroy = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/makanan/{makanan}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\MakananController::destroy
 * @see app/Http/Controllers/MakananController.php:48
 * @route '/makanan/{makanan}'
 */
destroy.url = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { makanan: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { makanan: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    makanan: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        makanan: typeof args.makanan === 'object'
                ? args.makanan.id
                : args.makanan,
                }

    return destroy.definition.url
            .replace('{makanan}', parsedArgs.makanan.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\MakananController::destroy
 * @see app/Http/Controllers/MakananController.php:48
 * @route '/makanan/{makanan}'
 */
destroy.delete = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\MakananController::destroy
 * @see app/Http/Controllers/MakananController.php:48
 * @route '/makanan/{makanan}'
 */
    const destroyForm = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\MakananController::destroy
 * @see app/Http/Controllers/MakananController.php:48
 * @route '/makanan/{makanan}'
 */
        destroyForm.delete = (args: { makanan: number | { id: number } } | [makanan: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
const makanan = {
    index: Object.assign(index, index),
create: Object.assign(create, create),
store: Object.assign(store, store),
show: Object.assign(show, show),
edit: Object.assign(edit, edit),
update: Object.assign(update, update),
destroy: Object.assign(destroy, destroy),
}

export default makanan