import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\PromoController::index
 * @see app/Http/Controllers/PromoController.php:11
 * @route '/promo'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/promo',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PromoController::index
 * @see app/Http/Controllers/PromoController.php:11
 * @route '/promo'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PromoController::index
 * @see app/Http/Controllers/PromoController.php:11
 * @route '/promo'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PromoController::index
 * @see app/Http/Controllers/PromoController.php:11
 * @route '/promo'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PromoController::index
 * @see app/Http/Controllers/PromoController.php:11
 * @route '/promo'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PromoController::index
 * @see app/Http/Controllers/PromoController.php:11
 * @route '/promo'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PromoController::index
 * @see app/Http/Controllers/PromoController.php:11
 * @route '/promo'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\PromoController::create
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/promo/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PromoController::create
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PromoController::create
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PromoController::create
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PromoController::create
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PromoController::create
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PromoController::create
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\PromoController::store
 * @see app/Http/Controllers/PromoController.php:19
 * @route '/promo'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/promo',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\PromoController::store
 * @see app/Http/Controllers/PromoController.php:19
 * @route '/promo'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PromoController::store
 * @see app/Http/Controllers/PromoController.php:19
 * @route '/promo'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\PromoController::store
 * @see app/Http/Controllers/PromoController.php:19
 * @route '/promo'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PromoController::store
 * @see app/Http/Controllers/PromoController.php:19
 * @route '/promo'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\PromoController::show
 * @see app/Http/Controllers/PromoController.php:35
 * @route '/promo/{promo}'
 */
export const show = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/promo/{promo}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PromoController::show
 * @see app/Http/Controllers/PromoController.php:35
 * @route '/promo/{promo}'
 */
show.url = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { promo: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { promo: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    promo: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        promo: typeof args.promo === 'object'
                ? args.promo.id
                : args.promo,
                }

    return show.definition.url
            .replace('{promo}', parsedArgs.promo.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PromoController::show
 * @see app/Http/Controllers/PromoController.php:35
 * @route '/promo/{promo}'
 */
show.get = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PromoController::show
 * @see app/Http/Controllers/PromoController.php:35
 * @route '/promo/{promo}'
 */
show.head = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PromoController::show
 * @see app/Http/Controllers/PromoController.php:35
 * @route '/promo/{promo}'
 */
    const showForm = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PromoController::show
 * @see app/Http/Controllers/PromoController.php:35
 * @route '/promo/{promo}'
 */
        showForm.get = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PromoController::show
 * @see app/Http/Controllers/PromoController.php:35
 * @route '/promo/{promo}'
 */
        showForm.head = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
/**
* @see \App\Http\Controllers\PromoController::edit
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/{promo}/edit'
 */
export const edit = (args: { promo: string | number } | [promo: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/promo/{promo}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PromoController::edit
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/{promo}/edit'
 */
edit.url = (args: { promo: string | number } | [promo: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { promo: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    promo: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        promo: args.promo,
                }

    return edit.definition.url
            .replace('{promo}', parsedArgs.promo.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PromoController::edit
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/{promo}/edit'
 */
edit.get = (args: { promo: string | number } | [promo: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PromoController::edit
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/{promo}/edit'
 */
edit.head = (args: { promo: string | number } | [promo: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PromoController::edit
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/{promo}/edit'
 */
    const editForm = (args: { promo: string | number } | [promo: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PromoController::edit
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/{promo}/edit'
 */
        editForm.get = (args: { promo: string | number } | [promo: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PromoController::edit
 * @see app/Http/Controllers/PromoController.php:0
 * @route '/promo/{promo}/edit'
 */
        editForm.head = (args: { promo: string | number } | [promo: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\PromoController::update
 * @see app/Http/Controllers/PromoController.php:40
 * @route '/promo/{promo}'
 */
export const update = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/promo/{promo}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\PromoController::update
 * @see app/Http/Controllers/PromoController.php:40
 * @route '/promo/{promo}'
 */
update.url = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { promo: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { promo: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    promo: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        promo: typeof args.promo === 'object'
                ? args.promo.id
                : args.promo,
                }

    return update.definition.url
            .replace('{promo}', parsedArgs.promo.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PromoController::update
 * @see app/Http/Controllers/PromoController.php:40
 * @route '/promo/{promo}'
 */
update.put = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\PromoController::update
 * @see app/Http/Controllers/PromoController.php:40
 * @route '/promo/{promo}'
 */
update.patch = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\PromoController::update
 * @see app/Http/Controllers/PromoController.php:40
 * @route '/promo/{promo}'
 */
    const updateForm = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PromoController::update
 * @see app/Http/Controllers/PromoController.php:40
 * @route '/promo/{promo}'
 */
        updateForm.put = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\PromoController::update
 * @see app/Http/Controllers/PromoController.php:40
 * @route '/promo/{promo}'
 */
        updateForm.patch = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\PromoController::destroy
 * @see app/Http/Controllers/PromoController.php:58
 * @route '/promo/{promo}'
 */
export const destroy = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/promo/{promo}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\PromoController::destroy
 * @see app/Http/Controllers/PromoController.php:58
 * @route '/promo/{promo}'
 */
destroy.url = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { promo: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { promo: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    promo: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        promo: typeof args.promo === 'object'
                ? args.promo.id
                : args.promo,
                }

    return destroy.definition.url
            .replace('{promo}', parsedArgs.promo.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PromoController::destroy
 * @see app/Http/Controllers/PromoController.php:58
 * @route '/promo/{promo}'
 */
destroy.delete = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\PromoController::destroy
 * @see app/Http/Controllers/PromoController.php:58
 * @route '/promo/{promo}'
 */
    const destroyForm = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PromoController::destroy
 * @see app/Http/Controllers/PromoController.php:58
 * @route '/promo/{promo}'
 */
        destroyForm.delete = (args: { promo: number | { id: number } } | [promo: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
const PromoController = { index, create, store, show, edit, update, destroy }

export default PromoController