import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\HistoriController::index
 * @see app/Http/Controllers/HistoriController.php:16
 * @route '/histori'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/histori',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HistoriController::index
 * @see app/Http/Controllers/HistoriController.php:16
 * @route '/histori'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::index
 * @see app/Http/Controllers/HistoriController.php:16
 * @route '/histori'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HistoriController::index
 * @see app/Http/Controllers/HistoriController.php:16
 * @route '/histori'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HistoriController::index
 * @see app/Http/Controllers/HistoriController.php:16
 * @route '/histori'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HistoriController::index
 * @see app/Http/Controllers/HistoriController.php:16
 * @route '/histori'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HistoriController::index
 * @see app/Http/Controllers/HistoriController.php:16
 * @route '/histori'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\HistoriController::create
 * @see app/Http/Controllers/HistoriController.php:52
 * @route '/histori/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/histori/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HistoriController::create
 * @see app/Http/Controllers/HistoriController.php:52
 * @route '/histori/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::create
 * @see app/Http/Controllers/HistoriController.php:52
 * @route '/histori/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HistoriController::create
 * @see app/Http/Controllers/HistoriController.php:52
 * @route '/histori/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HistoriController::create
 * @see app/Http/Controllers/HistoriController.php:52
 * @route '/histori/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HistoriController::create
 * @see app/Http/Controllers/HistoriController.php:52
 * @route '/histori/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HistoriController::create
 * @see app/Http/Controllers/HistoriController.php:52
 * @route '/histori/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\HistoriController::store
 * @see app/Http/Controllers/HistoriController.php:60
 * @route '/histori'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/histori',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\HistoriController::store
 * @see app/Http/Controllers/HistoriController.php:60
 * @route '/histori'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::store
 * @see app/Http/Controllers/HistoriController.php:60
 * @route '/histori'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\HistoriController::store
 * @see app/Http/Controllers/HistoriController.php:60
 * @route '/histori'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HistoriController::store
 * @see app/Http/Controllers/HistoriController.php:60
 * @route '/histori'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\HistoriController::show
 * @see app/Http/Controllers/HistoriController.php:68
 * @route '/histori/{histori}'
 */
export const show = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/histori/{histori}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HistoriController::show
 * @see app/Http/Controllers/HistoriController.php:68
 * @route '/histori/{histori}'
 */
show.url = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { histori: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { histori: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    histori: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        histori: typeof args.histori === 'object'
                ? args.histori.id
                : args.histori,
                }

    return show.definition.url
            .replace('{histori}', parsedArgs.histori.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::show
 * @see app/Http/Controllers/HistoriController.php:68
 * @route '/histori/{histori}'
 */
show.get = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HistoriController::show
 * @see app/Http/Controllers/HistoriController.php:68
 * @route '/histori/{histori}'
 */
show.head = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HistoriController::show
 * @see app/Http/Controllers/HistoriController.php:68
 * @route '/histori/{histori}'
 */
    const showForm = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HistoriController::show
 * @see app/Http/Controllers/HistoriController.php:68
 * @route '/histori/{histori}'
 */
        showForm.get = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HistoriController::show
 * @see app/Http/Controllers/HistoriController.php:68
 * @route '/histori/{histori}'
 */
        showForm.head = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
/**
* @see \App\Http\Controllers\HistoriController::edit
 * @see app/Http/Controllers/HistoriController.php:76
 * @route '/histori/{histori}/edit'
 */
export const edit = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/histori/{histori}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HistoriController::edit
 * @see app/Http/Controllers/HistoriController.php:76
 * @route '/histori/{histori}/edit'
 */
edit.url = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { histori: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { histori: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    histori: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        histori: typeof args.histori === 'object'
                ? args.histori.id
                : args.histori,
                }

    return edit.definition.url
            .replace('{histori}', parsedArgs.histori.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::edit
 * @see app/Http/Controllers/HistoriController.php:76
 * @route '/histori/{histori}/edit'
 */
edit.get = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HistoriController::edit
 * @see app/Http/Controllers/HistoriController.php:76
 * @route '/histori/{histori}/edit'
 */
edit.head = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HistoriController::edit
 * @see app/Http/Controllers/HistoriController.php:76
 * @route '/histori/{histori}/edit'
 */
    const editForm = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HistoriController::edit
 * @see app/Http/Controllers/HistoriController.php:76
 * @route '/histori/{histori}/edit'
 */
        editForm.get = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HistoriController::edit
 * @see app/Http/Controllers/HistoriController.php:76
 * @route '/histori/{histori}/edit'
 */
        editForm.head = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\HistoriController::update
 * @see app/Http/Controllers/HistoriController.php:84
 * @route '/histori/{histori}'
 */
export const update = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/histori/{histori}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\HistoriController::update
 * @see app/Http/Controllers/HistoriController.php:84
 * @route '/histori/{histori}'
 */
update.url = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { histori: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { histori: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    histori: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        histori: typeof args.histori === 'object'
                ? args.histori.id
                : args.histori,
                }

    return update.definition.url
            .replace('{histori}', parsedArgs.histori.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::update
 * @see app/Http/Controllers/HistoriController.php:84
 * @route '/histori/{histori}'
 */
update.put = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\HistoriController::update
 * @see app/Http/Controllers/HistoriController.php:84
 * @route '/histori/{histori}'
 */
update.patch = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\HistoriController::update
 * @see app/Http/Controllers/HistoriController.php:84
 * @route '/histori/{histori}'
 */
    const updateForm = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HistoriController::update
 * @see app/Http/Controllers/HistoriController.php:84
 * @route '/histori/{histori}'
 */
        updateForm.put = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\HistoriController::update
 * @see app/Http/Controllers/HistoriController.php:84
 * @route '/histori/{histori}'
 */
        updateForm.patch = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\HistoriController::destroy
 * @see app/Http/Controllers/HistoriController.php:152
 * @route '/histori/{histori}'
 */
export const destroy = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/histori/{histori}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\HistoriController::destroy
 * @see app/Http/Controllers/HistoriController.php:152
 * @route '/histori/{histori}'
 */
destroy.url = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { histori: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { histori: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    histori: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        histori: typeof args.histori === 'object'
                ? args.histori.id
                : args.histori,
                }

    return destroy.definition.url
            .replace('{histori}', parsedArgs.histori.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::destroy
 * @see app/Http/Controllers/HistoriController.php:152
 * @route '/histori/{histori}'
 */
destroy.delete = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\HistoriController::destroy
 * @see app/Http/Controllers/HistoriController.php:152
 * @route '/histori/{histori}'
 */
    const destroyForm = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HistoriController::destroy
 * @see app/Http/Controllers/HistoriController.php:152
 * @route '/histori/{histori}'
 */
        destroyForm.delete = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\HistoriController::pay
 * @see app/Http/Controllers/HistoriController.php:92
 * @route '/histori/{histori}/pay'
 */
export const pay = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: pay.url(args, options),
    method: 'post',
})

pay.definition = {
    methods: ["post"],
    url: '/histori/{histori}/pay',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\HistoriController::pay
 * @see app/Http/Controllers/HistoriController.php:92
 * @route '/histori/{histori}/pay'
 */
pay.url = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { histori: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { histori: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    histori: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        histori: typeof args.histori === 'object'
                ? args.histori.id
                : args.histori,
                }

    return pay.definition.url
            .replace('{histori}', parsedArgs.histori.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HistoriController::pay
 * @see app/Http/Controllers/HistoriController.php:92
 * @route '/histori/{histori}/pay'
 */
pay.post = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: pay.url(args, options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\HistoriController::pay
 * @see app/Http/Controllers/HistoriController.php:92
 * @route '/histori/{histori}/pay'
 */
    const payForm = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: pay.url(args, options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HistoriController::pay
 * @see app/Http/Controllers/HistoriController.php:92
 * @route '/histori/{histori}/pay'
 */
        payForm.post = (args: { histori: number | { id: number } } | [histori: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: pay.url(args, options),
            method: 'post',
        })
    
    pay.form = payForm
const HistoriController = { index, create, store, show, edit, update, destroy, pay }

export default HistoriController