import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\EspDeviceController::getDevices
 * @see app/Http/Controllers/EspDeviceController.php:140
 * @route '/api/devices'
 */
export const getDevices = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getDevices.url(options),
    method: 'get',
})

getDevices.definition = {
    methods: ["get","head"],
    url: '/api/devices',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\EspDeviceController::getDevices
 * @see app/Http/Controllers/EspDeviceController.php:140
 * @route '/api/devices'
 */
getDevices.url = (options?: RouteQueryOptions) => {
    return getDevices.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::getDevices
 * @see app/Http/Controllers/EspDeviceController.php:140
 * @route '/api/devices'
 */
getDevices.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getDevices.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\EspDeviceController::getDevices
 * @see app/Http/Controllers/EspDeviceController.php:140
 * @route '/api/devices'
 */
getDevices.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getDevices.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::getDevices
 * @see app/Http/Controllers/EspDeviceController.php:140
 * @route '/api/devices'
 */
    const getDevicesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: getDevices.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::getDevices
 * @see app/Http/Controllers/EspDeviceController.php:140
 * @route '/api/devices'
 */
        getDevicesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getDevices.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\EspDeviceController::getDevices
 * @see app/Http/Controllers/EspDeviceController.php:140
 * @route '/api/devices'
 */
        getDevicesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getDevices.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    getDevices.form = getDevicesForm
/**
* @see \App\Http\Controllers\EspDeviceController::checkOfflineDevices
 * @see app/Http/Controllers/EspDeviceController.php:316
 * @route '/api/devices/check-status'
 */
export const checkOfflineDevices = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkOfflineDevices.url(options),
    method: 'post',
})

checkOfflineDevices.definition = {
    methods: ["post"],
    url: '/api/devices/check-status',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\EspDeviceController::checkOfflineDevices
 * @see app/Http/Controllers/EspDeviceController.php:316
 * @route '/api/devices/check-status'
 */
checkOfflineDevices.url = (options?: RouteQueryOptions) => {
    return checkOfflineDevices.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::checkOfflineDevices
 * @see app/Http/Controllers/EspDeviceController.php:316
 * @route '/api/devices/check-status'
 */
checkOfflineDevices.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkOfflineDevices.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::checkOfflineDevices
 * @see app/Http/Controllers/EspDeviceController.php:316
 * @route '/api/devices/check-status'
 */
    const checkOfflineDevicesForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: checkOfflineDevices.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::checkOfflineDevices
 * @see app/Http/Controllers/EspDeviceController.php:316
 * @route '/api/devices/check-status'
 */
        checkOfflineDevicesForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: checkOfflineDevices.url(options),
            method: 'post',
        })
    
    checkOfflineDevices.form = checkOfflineDevicesForm
/**
* @see \App\Http\Controllers\EspDeviceController::getPorts
 * @see app/Http/Controllers/EspDeviceController.php:156
 * @route '/api/ports'
 */
export const getPorts = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getPorts.url(options),
    method: 'get',
})

getPorts.definition = {
    methods: ["get","head"],
    url: '/api/ports',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\EspDeviceController::getPorts
 * @see app/Http/Controllers/EspDeviceController.php:156
 * @route '/api/ports'
 */
getPorts.url = (options?: RouteQueryOptions) => {
    return getPorts.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::getPorts
 * @see app/Http/Controllers/EspDeviceController.php:156
 * @route '/api/ports'
 */
getPorts.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getPorts.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\EspDeviceController::getPorts
 * @see app/Http/Controllers/EspDeviceController.php:156
 * @route '/api/ports'
 */
getPorts.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getPorts.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::getPorts
 * @see app/Http/Controllers/EspDeviceController.php:156
 * @route '/api/ports'
 */
    const getPortsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: getPorts.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::getPorts
 * @see app/Http/Controllers/EspDeviceController.php:156
 * @route '/api/ports'
 */
        getPortsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getPorts.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\EspDeviceController::getPorts
 * @see app/Http/Controllers/EspDeviceController.php:156
 * @route '/api/ports'
 */
        getPortsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getPorts.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    getPorts.form = getPortsForm
/**
* @see \App\Http\Controllers\EspDeviceController::updateRelayName
 * @see app/Http/Controllers/EspDeviceController.php:342
 * @route '/api/relay/update-name'
 */
export const updateRelayName = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateRelayName.url(options),
    method: 'post',
})

updateRelayName.definition = {
    methods: ["post"],
    url: '/api/relay/update-name',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\EspDeviceController::updateRelayName
 * @see app/Http/Controllers/EspDeviceController.php:342
 * @route '/api/relay/update-name'
 */
updateRelayName.url = (options?: RouteQueryOptions) => {
    return updateRelayName.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::updateRelayName
 * @see app/Http/Controllers/EspDeviceController.php:342
 * @route '/api/relay/update-name'
 */
updateRelayName.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateRelayName.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::updateRelayName
 * @see app/Http/Controllers/EspDeviceController.php:342
 * @route '/api/relay/update-name'
 */
    const updateRelayNameForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: updateRelayName.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::updateRelayName
 * @see app/Http/Controllers/EspDeviceController.php:342
 * @route '/api/relay/update-name'
 */
        updateRelayNameForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: updateRelayName.url(options),
            method: 'post',
        })
    
    updateRelayName.form = updateRelayNameForm
/**
* @see \App\Http\Controllers\EspDeviceController::index
 * @see app/Http/Controllers/EspDeviceController.php:14
 * @route '/device'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/device',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\EspDeviceController::index
 * @see app/Http/Controllers/EspDeviceController.php:14
 * @route '/device'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::index
 * @see app/Http/Controllers/EspDeviceController.php:14
 * @route '/device'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\EspDeviceController::index
 * @see app/Http/Controllers/EspDeviceController.php:14
 * @route '/device'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::index
 * @see app/Http/Controllers/EspDeviceController.php:14
 * @route '/device'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::index
 * @see app/Http/Controllers/EspDeviceController.php:14
 * @route '/device'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\EspDeviceController::index
 * @see app/Http/Controllers/EspDeviceController.php:14
 * @route '/device'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\EspDeviceController::create
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/device/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\EspDeviceController::create
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::create
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\EspDeviceController::create
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::create
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::create
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\EspDeviceController::create
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\EspDeviceController::store
 * @see app/Http/Controllers/EspDeviceController.php:22
 * @route '/device'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/device',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\EspDeviceController::store
 * @see app/Http/Controllers/EspDeviceController.php:22
 * @route '/device'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::store
 * @see app/Http/Controllers/EspDeviceController.php:22
 * @route '/device'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::store
 * @see app/Http/Controllers/EspDeviceController.php:22
 * @route '/device'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::store
 * @see app/Http/Controllers/EspDeviceController.php:22
 * @route '/device'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\EspDeviceController::show
 * @see app/Http/Controllers/EspDeviceController.php:38
 * @route '/device/{device}'
 */
export const show = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/device/{device}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\EspDeviceController::show
 * @see app/Http/Controllers/EspDeviceController.php:38
 * @route '/device/{device}'
 */
show.url = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { device: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { device: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    device: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        device: typeof args.device === 'object'
                ? args.device.id
                : args.device,
                }

    return show.definition.url
            .replace('{device}', parsedArgs.device.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::show
 * @see app/Http/Controllers/EspDeviceController.php:38
 * @route '/device/{device}'
 */
show.get = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\EspDeviceController::show
 * @see app/Http/Controllers/EspDeviceController.php:38
 * @route '/device/{device}'
 */
show.head = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::show
 * @see app/Http/Controllers/EspDeviceController.php:38
 * @route '/device/{device}'
 */
    const showForm = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::show
 * @see app/Http/Controllers/EspDeviceController.php:38
 * @route '/device/{device}'
 */
        showForm.get = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\EspDeviceController::show
 * @see app/Http/Controllers/EspDeviceController.php:38
 * @route '/device/{device}'
 */
        showForm.head = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
/**
* @see \App\Http\Controllers\EspDeviceController::edit
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/{device}/edit'
 */
export const edit = (args: { device: string | number } | [device: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/device/{device}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\EspDeviceController::edit
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/{device}/edit'
 */
edit.url = (args: { device: string | number } | [device: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { device: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    device: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        device: args.device,
                }

    return edit.definition.url
            .replace('{device}', parsedArgs.device.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::edit
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/{device}/edit'
 */
edit.get = (args: { device: string | number } | [device: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\EspDeviceController::edit
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/{device}/edit'
 */
edit.head = (args: { device: string | number } | [device: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::edit
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/{device}/edit'
 */
    const editForm = (args: { device: string | number } | [device: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::edit
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/{device}/edit'
 */
        editForm.get = (args: { device: string | number } | [device: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\EspDeviceController::edit
 * @see app/Http/Controllers/EspDeviceController.php:0
 * @route '/device/{device}/edit'
 */
        editForm.head = (args: { device: string | number } | [device: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\EspDeviceController::update
 * @see app/Http/Controllers/EspDeviceController.php:43
 * @route '/device/{device}'
 */
export const update = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/device/{device}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\EspDeviceController::update
 * @see app/Http/Controllers/EspDeviceController.php:43
 * @route '/device/{device}'
 */
update.url = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { device: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { device: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    device: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        device: typeof args.device === 'object'
                ? args.device.id
                : args.device,
                }

    return update.definition.url
            .replace('{device}', parsedArgs.device.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::update
 * @see app/Http/Controllers/EspDeviceController.php:43
 * @route '/device/{device}'
 */
update.put = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\EspDeviceController::update
 * @see app/Http/Controllers/EspDeviceController.php:43
 * @route '/device/{device}'
 */
update.patch = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::update
 * @see app/Http/Controllers/EspDeviceController.php:43
 * @route '/device/{device}'
 */
    const updateForm = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::update
 * @see app/Http/Controllers/EspDeviceController.php:43
 * @route '/device/{device}'
 */
        updateForm.put = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\EspDeviceController::update
 * @see app/Http/Controllers/EspDeviceController.php:43
 * @route '/device/{device}'
 */
        updateForm.patch = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\EspDeviceController::destroy
 * @see app/Http/Controllers/EspDeviceController.php:56
 * @route '/device/{device}'
 */
export const destroy = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/device/{device}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\EspDeviceController::destroy
 * @see app/Http/Controllers/EspDeviceController.php:56
 * @route '/device/{device}'
 */
destroy.url = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { device: args }
    }

            if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
            args = { device: args.id }
        }
    
    if (Array.isArray(args)) {
        args = {
                    device: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        device: typeof args.device === 'object'
                ? args.device.id
                : args.device,
                }

    return destroy.definition.url
            .replace('{device}', parsedArgs.device.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\EspDeviceController::destroy
 * @see app/Http/Controllers/EspDeviceController.php:56
 * @route '/device/{device}'
 */
destroy.delete = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\EspDeviceController::destroy
 * @see app/Http/Controllers/EspDeviceController.php:56
 * @route '/device/{device}'
 */
    const destroyForm = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\EspDeviceController::destroy
 * @see app/Http/Controllers/EspDeviceController.php:56
 * @route '/device/{device}'
 */
        destroyForm.delete = (args: { device: number | { id: number } } | [device: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
const EspDeviceController = { getDevices, checkOfflineDevices, getPorts, updateRelayName, index, create, store, show, edit, update, destroy }

export default EspDeviceController