import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\PaketApiController::index
 * @see app/Http/Controllers/Api/PaketApiController.php:12
 * @route '/api/paket'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/api/paket',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\PaketApiController::index
 * @see app/Http/Controllers/Api/PaketApiController.php:12
 * @route '/api/paket'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\PaketApiController::index
 * @see app/Http/Controllers/Api/PaketApiController.php:12
 * @route '/api/paket'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Api\PaketApiController::index
 * @see app/Http/Controllers/Api/PaketApiController.php:12
 * @route '/api/paket'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Api\PaketApiController::index
 * @see app/Http/Controllers/Api/PaketApiController.php:12
 * @route '/api/paket'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Api\PaketApiController::index
 * @see app/Http/Controllers/Api/PaketApiController.php:12
 * @route '/api/paket'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Api\PaketApiController::index
 * @see app/Http/Controllers/Api/PaketApiController.php:12
 * @route '/api/paket'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
const PaketApiController = { index }

export default PaketApiController