import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\MakananApiController::index
 * @see app/Http/Controllers/Api/MakananApiController.php:10
 * @route '/api/makanan'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/api/makanan',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\MakananApiController::index
 * @see app/Http/Controllers/Api/MakananApiController.php:10
 * @route '/api/makanan'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\MakananApiController::index
 * @see app/Http/Controllers/Api/MakananApiController.php:10
 * @route '/api/makanan'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Api\MakananApiController::index
 * @see app/Http/Controllers/Api/MakananApiController.php:10
 * @route '/api/makanan'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Api\MakananApiController::index
 * @see app/Http/Controllers/Api/MakananApiController.php:10
 * @route '/api/makanan'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Api\MakananApiController::index
 * @see app/Http/Controllers/Api/MakananApiController.php:10
 * @route '/api/makanan'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Api\MakananApiController::index
 * @see app/Http/Controllers/Api/MakananApiController.php:10
 * @route '/api/makanan'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
const MakananApiController = { index }

export default MakananApiController