import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\EspController::heartbeat
 * @see app/Http/Controllers/Api/EspController.php:18
 * @route '/api/esp/heartbeat'
 */
export const heartbeat = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: heartbeat.url(options),
    method: 'post',
})

heartbeat.definition = {
    methods: ["post"],
    url: '/api/esp/heartbeat',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EspController::heartbeat
 * @see app/Http/Controllers/Api/EspController.php:18
 * @route '/api/esp/heartbeat'
 */
heartbeat.url = (options?: RouteQueryOptions) => {
    return heartbeat.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EspController::heartbeat
 * @see app/Http/Controllers/Api/EspController.php:18
 * @route '/api/esp/heartbeat'
 */
heartbeat.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: heartbeat.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\EspController::heartbeat
 * @see app/Http/Controllers/Api/EspController.php:18
 * @route '/api/esp/heartbeat'
 */
    const heartbeatForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: heartbeat.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\EspController::heartbeat
 * @see app/Http/Controllers/Api/EspController.php:18
 * @route '/api/esp/heartbeat'
 */
        heartbeatForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: heartbeat.url(options),
            method: 'post',
        })
    
    heartbeat.form = heartbeatForm
/**
* @see \App\Http\Controllers\Api\EspController::getRelayStatus
 * @see app/Http/Controllers/Api/EspController.php:61
 * @route '/api/esp/relay-status/{device_id}'
 */
export const getRelayStatus = (args: { device_id: string | number } | [device_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getRelayStatus.url(args, options),
    method: 'get',
})

getRelayStatus.definition = {
    methods: ["get","head"],
    url: '/api/esp/relay-status/{device_id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\EspController::getRelayStatus
 * @see app/Http/Controllers/Api/EspController.php:61
 * @route '/api/esp/relay-status/{device_id}'
 */
getRelayStatus.url = (args: { device_id: string | number } | [device_id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { device_id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    device_id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        device_id: args.device_id,
                }

    return getRelayStatus.definition.url
            .replace('{device_id}', parsedArgs.device_id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EspController::getRelayStatus
 * @see app/Http/Controllers/Api/EspController.php:61
 * @route '/api/esp/relay-status/{device_id}'
 */
getRelayStatus.get = (args: { device_id: string | number } | [device_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getRelayStatus.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Api\EspController::getRelayStatus
 * @see app/Http/Controllers/Api/EspController.php:61
 * @route '/api/esp/relay-status/{device_id}'
 */
getRelayStatus.head = (args: { device_id: string | number } | [device_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getRelayStatus.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Api\EspController::getRelayStatus
 * @see app/Http/Controllers/Api/EspController.php:61
 * @route '/api/esp/relay-status/{device_id}'
 */
    const getRelayStatusForm = (args: { device_id: string | number } | [device_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: getRelayStatus.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Api\EspController::getRelayStatus
 * @see app/Http/Controllers/Api/EspController.php:61
 * @route '/api/esp/relay-status/{device_id}'
 */
        getRelayStatusForm.get = (args: { device_id: string | number } | [device_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getRelayStatus.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Api\EspController::getRelayStatus
 * @see app/Http/Controllers/Api/EspController.php:61
 * @route '/api/esp/relay-status/{device_id}'
 */
        getRelayStatusForm.head = (args: { device_id: string | number } | [device_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getRelayStatus.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    getRelayStatus.form = getRelayStatusForm
/**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/esp/control-relay'
 */
const controlRelayaa30edf8d5a13c38deca06c3a539a519 = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlRelayaa30edf8d5a13c38deca06c3a539a519.url(options),
    method: 'post',
})

controlRelayaa30edf8d5a13c38deca06c3a539a519.definition = {
    methods: ["post"],
    url: '/api/esp/control-relay',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/esp/control-relay'
 */
controlRelayaa30edf8d5a13c38deca06c3a539a519.url = (options?: RouteQueryOptions) => {
    return controlRelayaa30edf8d5a13c38deca06c3a539a519.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/esp/control-relay'
 */
controlRelayaa30edf8d5a13c38deca06c3a539a519.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlRelayaa30edf8d5a13c38deca06c3a539a519.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/esp/control-relay'
 */
    const controlRelayaa30edf8d5a13c38deca06c3a539a519Form = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: controlRelayaa30edf8d5a13c38deca06c3a539a519.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/esp/control-relay'
 */
        controlRelayaa30edf8d5a13c38deca06c3a539a519Form.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: controlRelayaa30edf8d5a13c38deca06c3a539a519.url(options),
            method: 'post',
        })
    
    controlRelayaa30edf8d5a13c38deca06c3a539a519.form = controlRelayaa30edf8d5a13c38deca06c3a539a519Form
    /**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/relay/control'
 */
const controlRelay1878606038f524dffca9f177f2e0ef75 = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlRelay1878606038f524dffca9f177f2e0ef75.url(options),
    method: 'post',
})

controlRelay1878606038f524dffca9f177f2e0ef75.definition = {
    methods: ["post"],
    url: '/api/relay/control',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/relay/control'
 */
controlRelay1878606038f524dffca9f177f2e0ef75.url = (options?: RouteQueryOptions) => {
    return controlRelay1878606038f524dffca9f177f2e0ef75.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/relay/control'
 */
controlRelay1878606038f524dffca9f177f2e0ef75.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlRelay1878606038f524dffca9f177f2e0ef75.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/relay/control'
 */
    const controlRelay1878606038f524dffca9f177f2e0ef75Form = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: controlRelay1878606038f524dffca9f177f2e0ef75.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\EspController::controlRelay
 * @see app/Http/Controllers/Api/EspController.php:98
 * @route '/api/relay/control'
 */
        controlRelay1878606038f524dffca9f177f2e0ef75Form.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: controlRelay1878606038f524dffca9f177f2e0ef75.url(options),
            method: 'post',
        })
    
    controlRelay1878606038f524dffca9f177f2e0ef75.form = controlRelay1878606038f524dffca9f177f2e0ef75Form

export const controlRelay = {
    '/api/esp/control-relay': controlRelayaa30edf8d5a13c38deca06c3a539a519,
    '/api/relay/control': controlRelay1878606038f524dffca9f177f2e0ef75,
}

/**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/esp/control-multiple-relays'
 */
const controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.url(options),
    method: 'post',
})

controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.definition = {
    methods: ["post"],
    url: '/api/esp/control-multiple-relays',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/esp/control-multiple-relays'
 */
controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.url = (options?: RouteQueryOptions) => {
    return controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/esp/control-multiple-relays'
 */
controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/esp/control-multiple-relays'
 */
    const controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9dForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/esp/control-multiple-relays'
 */
        controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9dForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.url(options),
            method: 'post',
        })
    
    controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d.form = controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9dForm
    /**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/relay/control-multiple'
 */
const controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528 = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.url(options),
    method: 'post',
})

controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.definition = {
    methods: ["post"],
    url: '/api/relay/control-multiple',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/relay/control-multiple'
 */
controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.url = (options?: RouteQueryOptions) => {
    return controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/relay/control-multiple'
 */
controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/relay/control-multiple'
 */
    const controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528Form = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\EspController::controlMultipleRelays
 * @see app/Http/Controllers/Api/EspController.php:149
 * @route '/api/relay/control-multiple'
 */
        controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528Form.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.url(options),
            method: 'post',
        })
    
    controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528.form = controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528Form

export const controlMultipleRelays = {
    '/api/esp/control-multiple-relays': controlMultipleRelays826c404efaf1e6e8c1ff966e2f80be9d,
    '/api/relay/control-multiple': controlMultipleRelays7e797ae82e9ee24d4eb6b28d1c552528,
}

const EspController = { heartbeat, getRelayStatus, controlRelay, controlMultipleRelays }

export default EspController