import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\BillingController::start
 * @see app/Http/Controllers/Api/BillingController.php:19
 * @route '/api/billing/start'
 */
export const start = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: start.url(options),
    method: 'post',
})

start.definition = {
    methods: ["post"],
    url: '/api/billing/start',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\BillingController::start
 * @see app/Http/Controllers/Api/BillingController.php:19
 * @route '/api/billing/start'
 */
start.url = (options?: RouteQueryOptions) => {
    return start.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\BillingController::start
 * @see app/Http/Controllers/Api/BillingController.php:19
 * @route '/api/billing/start'
 */
start.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: start.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\BillingController::start
 * @see app/Http/Controllers/Api/BillingController.php:19
 * @route '/api/billing/start'
 */
    const startForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: start.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\BillingController::start
 * @see app/Http/Controllers/Api/BillingController.php:19
 * @route '/api/billing/start'
 */
        startForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: start.url(options),
            method: 'post',
        })
    
    start.form = startForm
/**
* @see \App\Http\Controllers\Api\BillingController::stop
 * @see app/Http/Controllers/Api/BillingController.php:122
 * @route '/api/billing/stop'
 */
export const stop = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: stop.url(options),
    method: 'post',
})

stop.definition = {
    methods: ["post"],
    url: '/api/billing/stop',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\BillingController::stop
 * @see app/Http/Controllers/Api/BillingController.php:122
 * @route '/api/billing/stop'
 */
stop.url = (options?: RouteQueryOptions) => {
    return stop.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\BillingController::stop
 * @see app/Http/Controllers/Api/BillingController.php:122
 * @route '/api/billing/stop'
 */
stop.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: stop.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\BillingController::stop
 * @see app/Http/Controllers/Api/BillingController.php:122
 * @route '/api/billing/stop'
 */
    const stopForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: stop.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\BillingController::stop
 * @see app/Http/Controllers/Api/BillingController.php:122
 * @route '/api/billing/stop'
 */
        stopForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: stop.url(options),
            method: 'post',
        })
    
    stop.form = stopForm
/**
* @see \App\Http\Controllers\Api\BillingController::cancel
 * @see app/Http/Controllers/Api/BillingController.php:202
 * @route '/api/billing/cancel'
 */
export const cancel = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: cancel.url(options),
    method: 'post',
})

cancel.definition = {
    methods: ["post"],
    url: '/api/billing/cancel',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\BillingController::cancel
 * @see app/Http/Controllers/Api/BillingController.php:202
 * @route '/api/billing/cancel'
 */
cancel.url = (options?: RouteQueryOptions) => {
    return cancel.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\BillingController::cancel
 * @see app/Http/Controllers/Api/BillingController.php:202
 * @route '/api/billing/cancel'
 */
cancel.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: cancel.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\BillingController::cancel
 * @see app/Http/Controllers/Api/BillingController.php:202
 * @route '/api/billing/cancel'
 */
    const cancelForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: cancel.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\BillingController::cancel
 * @see app/Http/Controllers/Api/BillingController.php:202
 * @route '/api/billing/cancel'
 */
        cancelForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: cancel.url(options),
            method: 'post',
        })
    
    cancel.form = cancelForm
/**
* @see \App\Http\Controllers\Api\BillingController::getActiveBilling
 * @see app/Http/Controllers/Api/BillingController.php:417
 * @route '/api/billing/active'
 */
export const getActiveBilling = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getActiveBilling.url(options),
    method: 'get',
})

getActiveBilling.definition = {
    methods: ["get","head"],
    url: '/api/billing/active',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\BillingController::getActiveBilling
 * @see app/Http/Controllers/Api/BillingController.php:417
 * @route '/api/billing/active'
 */
getActiveBilling.url = (options?: RouteQueryOptions) => {
    return getActiveBilling.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\BillingController::getActiveBilling
 * @see app/Http/Controllers/Api/BillingController.php:417
 * @route '/api/billing/active'
 */
getActiveBilling.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getActiveBilling.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Api\BillingController::getActiveBilling
 * @see app/Http/Controllers/Api/BillingController.php:417
 * @route '/api/billing/active'
 */
getActiveBilling.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getActiveBilling.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Api\BillingController::getActiveBilling
 * @see app/Http/Controllers/Api/BillingController.php:417
 * @route '/api/billing/active'
 */
    const getActiveBillingForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: getActiveBilling.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Api\BillingController::getActiveBilling
 * @see app/Http/Controllers/Api/BillingController.php:417
 * @route '/api/billing/active'
 */
        getActiveBillingForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getActiveBilling.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Api\BillingController::getActiveBilling
 * @see app/Http/Controllers/Api/BillingController.php:417
 * @route '/api/billing/active'
 */
        getActiveBillingForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: getActiveBilling.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    getActiveBilling.form = getActiveBillingForm
/**
* @see \App\Http\Controllers\Api\BillingController::checkExpiredTimedBillings
 * @see app/Http/Controllers/Api/BillingController.php:478
 * @route '/api/billing/check-expired'
 */
export const checkExpiredTimedBillings = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkExpiredTimedBillings.url(options),
    method: 'post',
})

checkExpiredTimedBillings.definition = {
    methods: ["post"],
    url: '/api/billing/check-expired',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\BillingController::checkExpiredTimedBillings
 * @see app/Http/Controllers/Api/BillingController.php:478
 * @route '/api/billing/check-expired'
 */
checkExpiredTimedBillings.url = (options?: RouteQueryOptions) => {
    return checkExpiredTimedBillings.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\BillingController::checkExpiredTimedBillings
 * @see app/Http/Controllers/Api/BillingController.php:478
 * @route '/api/billing/check-expired'
 */
checkExpiredTimedBillings.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkExpiredTimedBillings.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\BillingController::checkExpiredTimedBillings
 * @see app/Http/Controllers/Api/BillingController.php:478
 * @route '/api/billing/check-expired'
 */
    const checkExpiredTimedBillingsForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: checkExpiredTimedBillings.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\BillingController::checkExpiredTimedBillings
 * @see app/Http/Controllers/Api/BillingController.php:478
 * @route '/api/billing/check-expired'
 */
        checkExpiredTimedBillingsForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: checkExpiredTimedBillings.url(options),
            method: 'post',
        })
    
    checkExpiredTimedBillings.form = checkExpiredTimedBillingsForm
/**
* @see \App\Http\Controllers\Api\BillingController::tambahWaktu
 * @see app/Http/Controllers/Api/BillingController.php:272
 * @route '/api/billing/tambah-waktu'
 */
export const tambahWaktu = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: tambahWaktu.url(options),
    method: 'post',
})

tambahWaktu.definition = {
    methods: ["post"],
    url: '/api/billing/tambah-waktu',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\BillingController::tambahWaktu
 * @see app/Http/Controllers/Api/BillingController.php:272
 * @route '/api/billing/tambah-waktu'
 */
tambahWaktu.url = (options?: RouteQueryOptions) => {
    return tambahWaktu.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\BillingController::tambahWaktu
 * @see app/Http/Controllers/Api/BillingController.php:272
 * @route '/api/billing/tambah-waktu'
 */
tambahWaktu.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: tambahWaktu.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\BillingController::tambahWaktu
 * @see app/Http/Controllers/Api/BillingController.php:272
 * @route '/api/billing/tambah-waktu'
 */
    const tambahWaktuForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: tambahWaktu.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\BillingController::tambahWaktu
 * @see app/Http/Controllers/Api/BillingController.php:272
 * @route '/api/billing/tambah-waktu'
 */
        tambahWaktuForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: tambahWaktu.url(options),
            method: 'post',
        })
    
    tambahWaktu.form = tambahWaktuForm
/**
* @see \App\Http\Controllers\Api\BillingController::move
 * @see app/Http/Controllers/Api/BillingController.php:332
 * @route '/api/billing/move'
 */
export const move = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: move.url(options),
    method: 'post',
})

move.definition = {
    methods: ["post"],
    url: '/api/billing/move',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\BillingController::move
 * @see app/Http/Controllers/Api/BillingController.php:332
 * @route '/api/billing/move'
 */
move.url = (options?: RouteQueryOptions) => {
    return move.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\BillingController::move
 * @see app/Http/Controllers/Api/BillingController.php:332
 * @route '/api/billing/move'
 */
move.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: move.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\Api\BillingController::move
 * @see app/Http/Controllers/Api/BillingController.php:332
 * @route '/api/billing/move'
 */
    const moveForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: move.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\Api\BillingController::move
 * @see app/Http/Controllers/Api/BillingController.php:332
 * @route '/api/billing/move'
 */
        moveForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: move.url(options),
            method: 'post',
        })
    
    move.form = moveForm
const BillingController = { start, stop, cancel, getActiveBilling, checkExpiredTimedBillings, tambahWaktu, move }

export default BillingController