<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('makanans', function (Blueprint $table) {
            $table->id();
            $table->string('nama'); // Nama makanan/minuman
            $table->enum('kategori', ['Makanan', 'Minuman']); // Pilihan kategori
            $table->integer('stok')->default(0); // Jumlah stok
            $table->integer('harga')->default(0); // Harga
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('makanans');
    }
};
