<?php

namespace App\Http\Controllers;

use App\Models\Makanan;
use Illuminate\Http\Request;
use Inertia\Inertia;

class MakananController extends Controller
{
    public function index()
    {
        $makanan = Makanan::latest()->get();

        return Inertia::render('makanan/index', [
            'makanan' => $makanan,
        ]);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'nama' => 'required|string|max:255',
            'kategori' => 'required|string',
            'stok' => 'required|integer|min:0',
            'harga' => 'required|integer|min:0',
        ]);

        Makanan::create($validated);

        return back()->with('success', 'Makanan berhasil ditambahkan.');
    }

    public function update(Request $request, Makanan $makanan)
    {
        $validated = $request->validate([
            'nama' => 'required|string|max:255',
            'kategori' => 'required|string',
            'stok' => 'required|integer|min:0',
            'harga' => 'required|integer|min:0',
        ]);

        $makanan->update($validated);

        return back()->with('success', 'Makanan berhasil diperbarui.');
    }

    public function destroy(Makanan $makanan)
    {
        $makanan->delete();

        return back()->with('success', 'Makanan berhasil dihapus.');
    }
}
